# Copyright (C) 2013-2023 Echelon Corporation.  All Rights Reserved.
# Use of this code is subject to your compliance with the terms of the
# Echelon IzoT(tm) Software Developer's Kit License Agreement which is
# available at www.echelon.com/license/izot_sdk/.

# IzoT resources contained in this file are generated by an automated
# database to source code conversion process.  Grammar and punctuation within
# the embedded documentation may not be correct, as this data is gathered and
# combined from several sources.
# Names of resources and fields or members defined within a resource are
# derived from the same sources.  Names, capitalization and aspects of source
# code formatting may fail to comply with PEP-8 and PEP-257 recommendations
# due to the automated generation of these IzoT definitions.
# Generated at 11-May-2023 17:11.

"""occupancySensor2 userdefined profile, originally defined in resource file
set apollodev 90:00:01:06:00:00:00:00-4."""


import izot.resources.base
from P9000010600000000_4.userdefined import userdefined
import izot.resources.datapoints.occupancy
import izot.resources.properties.maxSendTime
import P9000010600000000_4.datapoints.setbackMinutes
import izot.resources.datapoints.switch_2
import izot.resources.properties.location
import izot.resources.properties.debounce
import P9000010600000000_4.properties.occCntlMode


class occupancySensor2(izot.resources.base.Profile):
    """occupancySensor2 userdefined profile.  Occupancy Sensor.  Used in a
    device with a hardware sensor whose output is either in an occupied or
    unoccupied state."""

    def __init__(self):
        super().__init__(
            key=20060,
            scope=4,
            principal='nvoOccup'
        )
        self.datapoints['nvoOccup'] = izot.resources.base.Profile.DatapointMember(
            doc="""Occupancy Provides the qualified state of the hardware
            sensor output.""",
            name='nvoOccup',
            profile=self,
            number=1,
            datatype=izot.resources.datapoints.occupancy.occupancy,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT,
            properties={
                'cpHeartBeat':
                izot.resources.base.Profile.PropertyMember(
                    doc="""Maximum send time.  The maximum period of time
                    between consecutive transmissions of the current
                    value.""",
                    name='cpHeartBeat',
                    profile=self,
                    number=5,
                    datatype=izot.resources.properties.maxSendTime.maxSendTime,
                    default=b'\x04\xb0',
                    mandatory=True
                )
            }
        )
        self.datapoints['nvoLowEmin'] = izot.resources.base.Profile.DatapointMember(
            doc=""" """,
            name='nvoLowEmin',
            profile=self,
            number=4,
            datatype=P9000010600000000_4.datapoints.setbackMinutes.setbackMinutes,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.datapoints['nvoSw2Value'] = izot.resources.base.Profile.DatapointMember(
            doc="""Switch with scene and setting control.  An enhanced
            version of SNVT_switch with scene and setting controls similar to
            SNVT_scene and SNVT_setting.""",
            name='nvoSw2Value',
            profile=self,
            number=5,
            datatype=izot.resources.datapoints.switch_2.switch_2,
            mandatory=True,
            direction=izot.resources.base.Profile.DatapointMember.OUTPUT
        )
        self.properties['nciLocation'] = izot.resources.base.Profile.PropertyMember(
            doc="""Location Provides descriptive physical location
            information related to the object.""",
            name='nciLocation',
            profile=self,
            number=1,
            datatype=izot.resources.properties.location.location,
            mandatory=False
        )
        self.properties['nciDebounce'] = izot.resources.base.Profile.PropertyMember(
            doc="""Debounce time.  The debouncing time to generate the
            detection envelope.""",
            name='nciDebounce',
            profile=self,
            number=3,
            datatype=izot.resources.properties.debounce.debounce,
            default=b'\x00\x00',
            mandatory=False
        )
        self.properties['cpControlMode'] = izot.resources.base.Profile.PropertyMember(
            doc=""" """,
            name='cpControlMode',
            profile=self,
            number=4,
            datatype=P9000010600000000_4.properties.occCntlMode.occCntlMode,
            default=b'\x01',
            mandatory=True
        )
        self._original_name = 'UFPToccupancySensor2'
        self._definition = userdefined.add(self)
        self.finalize()


if __name__ == '__main__':
    # unit test code.
    item = occupancySensor2()
    pass
